package gov.va.med.mhv.health.service.impl;

import gov.va.med.mhv.health.converter.AllergiesConverter;
import gov.va.med.mhv.health.dto.AllergyDTO;
import gov.va.med.mhv.health.dto.ResponseUtil;
import gov.va.med.mhv.health.model.Allergy;
import gov.va.med.mhv.health.repository.AllergyRepository;
import gov.va.med.mhv.health.service.AllergyService;
import gov.va.med.mhv.health.validator.AllergyValidator;

import java.util.LinkedHashMap;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class AllergyServiceImpl implements AllergyService{
	
	private static Logger log = LogManager.getLogger(AllergyServiceImpl.class);
	
	@Autowired
	private AllergyRepository allergyRepository;
	
	
	@Autowired
	private AllergyValidator validator;


	@Override
	public ResponseUtil save(AllergyDTO allergyDTO) {
		
		ResponseUtil response = new ResponseUtil();
		response.setValidationErrors(new LinkedHashMap<String, String>());
		validator.allergyValidations(response, allergyDTO);
		if(response.getValidationErrors().size() == 0){
			Allergy allergy = AllergiesConverter.convertAllergiesDTO(allergyDTO);
			allergyRepository.save(allergy);
			response.setSuccess(true);
		}else{
			log.debug("Validation Errors in Allergy record save:");
		}
		return response;
	}

	@Override
	public ResponseUtil delete(Long id) {
		ResponseUtil response = new ResponseUtil();
		allergyRepository.delete(id);
		response.setSuccess(true);
		return response;
	}

	@Override
	public ResponseUtil findByPrimaryKey(Long id) {
		ResponseUtil response = new ResponseUtil();
		Allergy allergy = allergyRepository.findOne(id);
		if(allergy != null){
			AllergyDTO allergyDTO = AllergiesConverter.convertAllergiesDomain(allergy);
			response.setPojoObject(allergyDTO);
			response.setSuccess(true);
		}else{
			log.debug("Allergy Record not found for id:");
			log.debug(id);
		}
		return response;
	}

	@Override
	public ResponseUtil findAllergiesForUser(Long userprofileid) {
		ResponseUtil response = new ResponseUtil();
		List<Allergy> allergies=allergyRepository.getAllergiesForUser(userprofileid);
		if(allergies != null){
			List<AllergyDTO> dtos = AllergiesConverter.convertAllergiesRecords(allergies);
			response.setPojoObject(dtos);
		}else{
			log.debug("Allergy Records not found for userprofileid:");
			log.debug(userprofileid);
		}
		response.setSuccess(true);
		return response;
	}

	@Override
	public ResponseUtil findDashBoardAllergiesForUser(Long userprofileid) {
		ResponseUtil response = new ResponseUtil();
		Pageable topFive = new  PageRequest(0,5);
		List<Allergy> allergies=allergyRepository.getDashBoardAllergiesForUser(userprofileid, topFive);
		if(allergies != null){
			List<AllergyDTO> dtos = AllergiesConverter.convertAllergiesRecords(allergies);
			response.setPojoObject(dtos);
		}else{
			log.debug("Allergy Dashboard Records not found for userprofileid:");
			log.debug(userprofileid);
		}
		response.setSuccess(true);
		return response;
	}

}
